/*
 * Decompiled with CFR 0.152.
 */
package uk.co.demon.obelisk.xlnk;

import java.io.File;
import java.io.FileOutputStream;
import uk.co.demon.obelisk.xlnk.CachedTarget;

public class BinTarget
extends CachedTarget {
    public BinTarget(long start, long end) {
        this(start, end, 8);
    }

    public BinTarget(long start, long end, int byteSize) {
        super(start, end, byteSize);
    }

    public void writeTo(File file) {
        try {
            FileOutputStream stream = new FileOutputStream(file);
            byte[] bytes = new byte[this.code.length * (this.getByteSize() / 8)];
            int offset = 0;
            switch (this.getByteSize()) {
                case 8: {
                    int index = 0;
                    while (index < this.code.length) {
                        bytes[offset++] = (byte)this.code[index];
                        ++index;
                    }
                    break;
                }
                case 16: {
                    int index = 0;
                    while (index < this.code.length) {
                        bytes[offset++] = (byte)(this.code[index] >> 8 & 0xFF);
                        bytes[offset++] = (byte)(this.code[index] >> 0 & 0xFF);
                        ++index;
                    }
                    break;
                }
            }
            stream.write(bytes);
            stream.close();
        }
        catch (Exception error) {
            System.err.println("Error: A serious error occurred while writing the object file.");
        }
    }
}

